close all
clear all
global u_t u_t1 jft
warning off
clc

addpath('C:\Dropbox\bpea\forecasts');

% Import forecasts over 1976-2006
% actual ur :
ur=csvread('v1ur.csv',75,1);
Tend=372; %for 2006
ur=ur(1:Tend,:);
ur0=ur;

uf_ARIMA=csvread('ur_arima.csv',75,1);
uf_ARIMA=uf_ARIMA(1:Tend,:);
uf_Ubar=csvread('ur_ustar.csv',75,1);
uf_Ubar=uf_Ubar(1:Tend,:);
uf_GB=csvread('ur_gb.csv',75,1);
uf_GB=uf_GB(1:Tend,:);
uf_SPF=csvread('ur_spf.csv',75,1);
uf_SPF=uf_SPF(1:Tend,:);
%NOTE: this is SSUR2 in real time
uf_SSUR2=csvread('ur_ssur2.csv',75,1);
uf_SSUR2=uf_SSUR2(1:Tend,:);
uf_VAR=csvread('ur_var.csv',75,1);
uf_VAR=uf_VAR(1:Tend,:);

eSSUR2=uf_SSUR2-ur;
uf_Staff=[uf_GB uf_SPF uf_ARIMA uf_Ubar uf_VAR];

name=['eGB '; 'eSPF'; 'eARI'; 'eUba'; 'eVAR'];

eSS=eSSUR2;ur=ur0;

for j=1:round(size(uf_Staff,2)/4)-1
    
    uStaff=uf_Staff(:,1+(j-1)*5:(j)*5);
    
    % I get rid of the rows with zeros for each forecast (so diff nbs of obs for each forecast comparison)
    eSS=eSSUR2;ur=ur0;
    
    %I get rid of the rows with zeros (ie no forecasts)
    [rows,cols,vals] = find(uStaff(:,1)==0);
    uStaff(rows,:)=[];
    ur(rows,:)=[];
    eSS(rows,:)=[];
    
    
     eStaff=(10000*uStaff)/10000-(10000*ur)/10000;
     RMSE_SSUR2=((sum((100*eSS).^2,1))./length(eSS)).^.5
%     
    disp('**********')
    disp(horzcat('Relative MSE ofSSUR forecast:' ));
    disp(horzcat('Var_' ,num2str(name(j,:)), 'model / Var SS model:' ));
    disp(num2str(sum(eStaff.^2,1)./sum(eSS.^2,1)))
    
    dssr=eStaff.^2-eSS.^2;
    disp(horzcat([' ']));
    Pval=[];
    for i=1:size(eSS,2)
        [teststat,critval,pval]=CPAtest(dssr(:,i),ones(length(dssr),1),i);
        Pval=[Pval pval];
    end
    disp(horzcat('Giacomini-White test at forecast horizon, p-values' ));
    disp(num2str(Pval))
end


% XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX
% Caluculate optimal forecast combination
% XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX


optwght=[];optwghtbd=[];varfin=[];comb0=[];comb=[];
optwght_MLE=[];optwghtbd_MLE=[];varfin_MLE=[];comb0_MLE=[];comb_MLE=[];


forvec=[uf_SSUR2 uf_SPF uf_ARIMA];
name=['  SSU2     ' '  eSPF     ' '  eARI     ' '  c     '];
ur=ur0;

% I get rid of the rows with zeros (ie no forecasts)
[rows,cols,vals] = find(forvec==0);
forvec(unique(sort(rows)),:)=[];
ur(unique(sort(rows)),:)=[];

Tr=0;
forvec=forvec(1:end-Tr,:);
ur=ur(1:end-Tr,:);

%rolling-regression or recursive for the optimal weights
%Here, we choose recursive
Tinit=1; Tstart=60; %(start estimation with first 15 years of data)
% for rolling, replace Tinit with j-Tstart+1

for j=Tstart:length(forvec)    
    comb00=[];comb_=[];
    for ii=1:5
        
        fv=[forvec(:,ii:5:size(forvec,2)) ones(length(forvec(:,ii)),1)];
        % fv=fv(j-59:j,:);
        
        %using OLS
        % vector of forecasts to be combined:
        
        [optwght(ii,:) bd_temp]= regress(ur(Tinit:j,ii),fv(Tinit:j,:));
        % -4 because at longer forecast horizing, we don't have the last data points
        optwghtbd(ii,:)=abs(bd_temp(:,1)-bd_temp(:,2))/4; % --> std errors
        %    comb0=[comb0  optwght(ii,1)*eStaff(:,ii)+optwght(ii,2)*eSS(:,ii)];
        
        if j==Tstart
            comb0=[comb0  fv*optwght(ii,:)'];
            %comb0=[comb0 fminbnd(@(x) ssr2(x,ii), 0, 1)*eStaff(:,ii)+(1-fminbnd(@(x) ssr2(x,ii), 0, 1))*eSS(:,ii)];
            comb=[comb comb0(:,ii)];
        else
            comb00=[comb00  fv(j,:)*optwght(ii,:)'];
            comb_=[comb_ comb00(:,ii)];
        end
    end
    if j~=Tstart
        comb(j,:)=comb_;
    end
    
end


eCOMB=(ur-comb);
eSSUR2=(ur-forvec(:,1:5));
eSPF=round(10000*(ur))/10000-round(10000*forvec(:,6:10))/10000; %round to one decimal after Ur (eg 8.1% consistent with the reporting of SPF and GB data)
eARIMA=(ur-forvec(:,11:15));

%Benchmark forecast to use as comparison
eBM=eSPF;


disp('**********')
disp(horzcat('Optimal weights for forecast SSUR/SPF:' ));
disp(horzcat(num2str(name)));
disp(num2str(optwght))
disp(horzcat('Std errors optimal weights for forecast SSUR/Greenbook:' ));
disp(horzcat(num2str(name)));
disp(num2str(optwghtbd))

disp('**********')
disp(horzcat('relative MSE of optimal combined forecast SSUR/Greenbook:' ));
disp(num2str(sum(eCOMB.^2,1)./sum(eBM.^2,1)))

dssr=(eCOMB).^2-(eBM).^2;
%dssr=dssr(75:end,:);
disp(horzcat([' ']));
Pval=[];
for i=1:size(eCOMB,2)
    [teststat,critval,pval]=CPAtest(dssr(:,i),ones(length(dssr),1),i);
    %disp(horzcat(['Giacomini-White test at forecast horizon, p-values  ', num2str(i)], ':   ', num2str(pval) ));
    Pval=[Pval pval];
end
disp(horzcat('Giacomini-White test at forecast horizon, p-values' ));
disp(num2str(Pval))

RMSE_SSUR2=((sum((100*eSSUR2).^2,1))./length(eSSUR2)).^.5

RMSE_SPF=((sum((100*eSPF).^2,1))./length(eSPF)).^.5

RMSE_ARIMA=((sum((100*eARIMA).^2,1))./length(eARIMA)).^.5

RMSE_COMB=((sum((100*eCOMB).^2,1))./length(eCOMB)).^.5

